//
//  ContentView.swift
//  HealtKitInformation
//
//  Created by Matteo Altobello on 16/04/25.
//

import SwiftUI

struct ContentView: View {
    @State private var viewModel = HealthDataViewModel()

    var body: some View {
        NavigationStack {
            VStack(spacing: 20) {
                if let error = viewModel.errorMessage {
                    Text("Error: \(error)")
                        .foregroundColor(.red)
                } else if viewModel.isAuthorized {
                    VStack(spacing: 16) {
                            HealthInfoView(
                                label: Text("Step Count"),
                                value: Text("\(Int(viewModel.stepCount)) steps")
                            )

                            HealthInfoView(
                                label: Text("Heart Rate"),
                                value: Text(String(format: "%.1f bpm", viewModel.heartRate)),
                                color: .red
                            )

                            HealthInfoView(
                                label: Text("Active Energy"),
                                value: Text(String(format: "%.1f kcal", viewModel.activeEnergy)),
                                color: .green
                            )
                        }
                } else {
                    ProgressView("Requesting HealthKit authorization...")
                                            .padding()
                }
            }
            .navigationTitle("Health Data")
        }
    }
}

struct HealthInfoView<Label: View, Value: View>: View {
    let label: Label
    let value: Value
    var color: Color = .orange

    var body: some View {
        RoundedRectangle(cornerRadius: 25)
            .fill(color.gradient)
            .frame(width: 200, height: 150)
            .overlay {
                VStack {
                    label
                    value
                }
                .font(.title2)
                .fontWeight(.bold)
                .foregroundColor(.white)
                .padding()
            }
    }
}




#Preview {
    ContentView()
}

