//
//  WorkoutMetrics.swift
//  TrackWorkoutsSampleProject
//
//  Created by Letizia Granata on 27/08/25.
//

// Data model to hold all workout metrics in one place
import Foundation

// Structure to hold all workout metrics that we display to the user
struct WorkoutMetrics {
    var heartRate: Double = 0.0           // Current heart rate in BPM
    var totalCalories: Double = 0.0       // Total calories burned
    var totalDistance: Double = 0.0       // Total distance in meters
    var elapsedTime: TimeInterval = 0.0   // Total workout time in seconds
    var isHeartRateAvailable: Bool = false // Whether heart rate data is available
    
    // Reset all metrics to zero (used when starting a new workout)
    mutating func reset() {
        heartRate = 0.0
        totalCalories = 0.0
        totalDistance = 0.0
        elapsedTime = 0.0
        isHeartRateAvailable = false
    }
}
