//
//  BooksShelfTransferableApp.swift
//  BooksShelfTransferable
//
//  Created by Giugliano Antonella on 05/01/26.
//

import SwiftUI
import AppIntents
import SwiftData

@main
struct BooksShelfTransferableApp: App {
    let modelContainer = DataModel.shared.modelContainer
    let navigationManager: NavigationManager

    init() {
        let navigationManager = NavigationManager()
        AppDependencyManager.shared.add(dependency: navigationManager)
        self.navigationManager = navigationManager
    }
    
    var body: some Scene {
        WindowGroup {
            BooksListView()
        }
        .environment(navigationManager)
        .modelContainer(modelContainer)
    }
}
