//
//  AddTestingBooksListIntent.swift
//  BooksShelfTransferable
//
//  Created by Giugliano Antonella on 05/01/26.
//

import AppIntents
import SwiftUI
import SwiftData

struct AddTestingBooksListIntent: AppIntent {
    
    static var title: LocalizedStringResource = "Add a testing books list to your Shelf"
    
    @MainActor
    func perform() async throws -> some IntentResult & ProvidesDialog {
        
        let testingBooks = [
            Book(title: "A Game of Throne (A Song of Fire and Ice #1)",
                 author: "George R.R. Martin", genre: .fantasy, contentType: .physicalBook),
            Book(title: "Wuthering Heights",author: "Emily Brontë", genre: Genre.romance, contentType: .physicalBook),
            Book(title: "Persuasion", author: "Jane Austen", genre: Genre.romance, contentType: .eBook),
            Book(title: "1984",author: "G. Orwell", genre: Genre.fantasy, contentType: .eBook),
            Book(title: "To Kill a Mockingbird", author: "Harper Lee",genre: Genre.romance, contentType: .eBook),
            Book(title: "Dune", author: "Frank Herbert", genre: Genre.scienceFiction, contentType: .physicalBook)
        ]
        let modelContext = ModelContext(DataModel.shared.modelContainer)
        do{
            for book in testingBooks {
                modelContext.insert(book)
            }
            try modelContext.save()
        }catch{
            fatalError("Unable to save the book")
        }
        BookShelfShortcutsProvider.updateAppShortcutParameters()
        
        let dialog = IntentDialog("New books added on your shelf.")
        return .result(dialog: dialog)
    }
}

