//
//  SearchIntent.swift
//  BooksShelfTransferable
//
//  Created by Giugliano Antonella on 24/03/25.
//

import AppIntents

@AssistantIntent(schema: .system.search)
struct BooksSearchLibraryIntent: ShowInAppSearchResultsIntent {
    static var searchScopes: [StringSearchScope] = [.general]

    var criteria: StringSearchCriteria
    
    @Dependency
    var navigationManager: NavigationManager
    
    @MainActor
    func perform() async throws -> some IntentResult {
        
        let searchString = criteria.term
        navigationManager.openSearch(with: searchString)
        return .result()
    }
}
