//
//  Data.swift
//  BooksShelfTransferable
//
//  Created by Giugliano Antonella on 04/03/25.
//
import SwiftUI
import SwiftData

actor DataModel {
    static let shared = DataModel()
    
    private init() {}
    
    nonisolated lazy var modelContainer: ModelContainer = {
        let modelContainer: ModelContainer
        
        do {
            modelContainer = try ModelContainer(for: Book.self)
        } catch {
            fatalError("Model container not created: \(error)")
        }
        
        return modelContainer
    }()
}
